'Programm ......... : Elektronische Sicherung ESS
'
'Programminhalt ... : - Einlesen des stromproportionalen Spannungswertes eines
'                       Stromsensors
'                     - Funktionen:
'                       > manuelles Ein- und Ausschalten
'
'Programmierer .... : Ingolf Bauer (ingolf.bauer@nexgo.de)
'Version .......... : 1.0.94
'Datum ............ : 08.02.2012
'
'-------------------------------------------------------------------------------
'
'Simulator-Einstellmglichkeit
'-----------------------------
'$sim                                              'Wartezeit aus
'
' Achtung!
' Diese Zeile unbedingt auskommentieren, bevor der AVR programmiert wird, da
' sonst der AVR nicht korrekt arbeitet.
' Die Aktivierung ist nur fr den Simulator vorgesehen.
'
'-------------------------------------------------------------------------------
'
'Information
'-----------
'
'
'
'
'-------------------------------------------------------------------------------
'
'Versionsbersicht
'-----------------
'
'
'
'
'
'V 1.1.94  08.02.2012 - Information . : - berarbeitung LED-Anzeige
'V 1.1.95  05.02.2012 - Information . : - Stromberwachung
'V 1.0.99  30.01.2012 - Information . : - Beginn der Softwareentwicklung
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'
'Programmspeicher des MCs (Programm-Flashspeicher): V 1.1.94 - 97%
'
'-------------------------------------------------------------------------------
'
'Informationen zur Software
'--------------------------
' Inhalt                                                                | Zeile
'-------------------------------------------------------------------------------
' 01. Allgemeine Informationen ........................................ |   97
'      Taktfrequenz ................................................... |  100
'      Programmierung ................................................. |  110
'      Powerdown ...................................................... |  118
' 02. Abkrzungsbersicht ............................................. |  125
' 03. Compilereinstellungen ........................................... |  129
' 04. Funktionsbeschreibung ........................................... |  154
'       Allgemeines ................................................... |  157
' 05. Interrupt ....................................................... |  183
' 06. Einstellung der FUSE- und/oder LOOK-Bits ........................ |  187
' 07. Anschluschema .................................................. |  200
'      AVR ATtiny13 ................................................... |  203
' 08. I/O-Ports ....................................................... |  214
'      Abkrzungen fr die Signalbezeichnung .......................... |  217
'      Portbelegung ................................................... |  229
' 09. Steckverbinder .................................................. |  247
' 10. Definition ...................................................... |  253
'      Schaltkreis .................................................... |  256
'      Schnittstelle .................................................. |  265
'      Compilereinstellungen .......................................... |  269
' 11. Deklaration ..................................................... |  276
' 12. Konfiguration ................................................... |  294
'      I/O-Port ....................................................... |  297
'      Timer .......................................................... |  307
'      ADC ............................................................ |  320
'      Interrupt ...................................................... |  328
' 13. Alias ........................................................... |  334
'      Eingang (digital) .............................................. |  337
'      Ausgang (digital) .............................................. |  343
' 14. Initialisierung ................................................. |  350
'      Blinken ........................................................ |  353
' 20. Programm ........................................................ |  365
'      Tastenabfrage .................................................. |  369
'      Schalten ....................................................... |  383
'      Fehler ......................................................... |  394
' 30. Unterprogramm ................................................... |  413
' 40. Interruptroutine ................................................ |  417
'      Timer 0 ........................................................ |  421
'      Ermittlung und Prfung des Stromwertes ......................... |  446
' 50. Unterprogramm-Call .............................................. |  480
' 60. Funktion ........................................................ |  484
' 70. Datenbereich .................................................... |  488
'-------------------------------------------------------------------------------
'
'01. Allgemeine Informationen
'----------------------------
'Taktfrequenz
'------------
' Als Taktgenerator wird der interne Taktgenerator, der per "default" einge-
' stellt ist, verwendet.
'                       CKSEL1 CKSEL0
' intern 4,8 MHz          0      1
' intern 9,6 MHz          1      0      (Frequenz im Programm verwendet)
' extern                  0      0
' 128 kHz intern          1      1
'
'Programmierung
'--------------
' Die Programmierung der MC kann extern oder ber die vorhandene Schnittstelle
' erfolgen.
' Zur Programmierung wurde das Modul "USBasp" verwendet, welches ber eine
' USB-Schnittstelle angeschlossen wird. Es kann direkt ber eine, in BASCOM
' integrierte Einstellung angesprochen werden.
'
'Powerdown
'---------
' Der Powerdown-Modus wird bei dieser Schaltung nicht verwendet.
'
' Der ATtiny13 lt sich nur per Interrupt aus dem Powerdown-Modus aufwecken,
' wenn es sich um einen Lowlevel-Interrupt handelt.
' Eine andere Mglichkeit ist die Verwendung des Reset-Signals.
'
'02. Abkrzungsbersicht
'-----------------------
' HLS ... : Halbleiterschalter

'03. Compilereinstellungen
'-------------------------
' Hinweise fr ATmega8/ATmega16 mit 1024 Byte SRAM
' Sie gelten ggf. auch fr den hier eingesetzten Mikrocontroller.
'
' Quelle:
' //halvar.at/elektronik/kleiner_bascom_avr_kurs/speicher_hwstack_swstack_frame/
'
' HW-Stack    - Empfehlung: 40 Byte bei INT, sonst 10 Byte ausreichend
'  32 Byte fr INT + je GOSUB 2 Byte, wenn bei INT ein GOSUB erfolgt
'  (bei Verschachtelung ... + n x 2 Byte)
'
' SW-Stack    - Empfehlung: 32 Byte (recht komplexe Aufrufe werden abgedeckt)
'   2 Byte fr jede bergebene Variable einer GOSUB-Routine + 2 Byte fr jede
'   LOCAL-Variable innerhalb einer GOSUB
'   (bei Verschachtelung ... n x 2 Byte)
'
' Frame-Space - Empfehlung: 60 Byte sollten alles abdecken
'                           (bei wenig Speicherverkleinern)
'  Beispiel:
'   2 x BYTE        =  2 Byte (erster und zweiter Parameter)
'   1 x WORD        =  2 Byte (dritte Parameter)
'   1 x STRING * 10 = 11 Byte (inkl. Abschlussbyte; vierter Parameter)
'   3 x BYTE        =  3 Byte (lokale Variablen)
'
'04. Funktionsbeschreibung
'-------------------------
' Allgemeines
' -----------
' Stromversorgung
' Fr die Spannungsstabilisierung wurde ein Festspannungsregler eingesetzt.
' Toleranzbedingte Abweichungen wirken sich auf die die Funktion des ESS (Ab-
' schaltwerte) aus und sind ggf. im Programm anzupassen.
'
' Bedienung
' Wird die ESS an eine Spannung angschlossen, startet das Programm im MC.
' Dies wird durch ein "Lebensbit" angezeigt, ein kurzes regelmiges Aufleuchten
' der vorhandenen LED.
' Durch einen Tastendruck wird beim Loslassen der Taste der HLS eingeschaltet.
' Ist weder eine Strung des HLS (Statusausgabe des HLS) oder ein Strom ober-
' halb der programmierten Ansprechschwelle vorhanden, schaltet der HLS die
' Betriebsspannung durch.
' Status- und Stromwert werden innerhalb der Interruptroutine berwacht.
' Bei einem Fehler oder einem zu hohen Stromwert zeigt die LED Dauerlicht.
' Nach Beseitigung des Fehlers kann mit dem Taster der HLS wieder eingeschaltet
' werden.
'
' Anmerkung
' Der folgende Programmcode soll als Anregungen fr eigene Softwarelsungen
' dienen. Zu beachten ist, dass der Flashspeicher relativ klein ist und zu-
' stzliche Funktionen nur schwer einfgbar sind.
' Etwas mehr Spielraum hat man da bei Einsatz der Baugruppe ESS_Z, bei dem
' ein ATmega16 zum Einsatz kommt.

'05. Interrupt
'-------------
' Timer 0:  8 Bit, Interrupt bei berlauf (interne Takterzeugung: 1 ms)
'
'06. Einstellung der FUSE- und/oder LOOK-Bits
'--------------------------------------------
' Fr die Einstellung der Fuse- und Lookbits ist der Bauanleitung ein "screen-
' shot" (Programmer: USBasp) beigelegt.
'
' Anpassungen sind bei der Verwendung des USBasp mit einem internen Brennpro-
' gramm von BASCOM mglich (z. B. Lschung des EEproms zusammen mit dem Brennen
' des Programms).
'
' /// Achtung ///
' Wenn aus Versehen die Funktion von Pin 1 von /Reset auf PB5 gendert wird,
' ist keine serielle Programmierung des AVR mehr mglich.
'
'07. Anschluschema
'------------------
'AVR ATtiny13
'------------
'                  -----------------|_|-----------------
' [~] /Reset ---> | 1 [/Reset, PB5]             [VCC] 8 | ==== P5V
' [0]    LED <--- | 2 [PB3]          [ADC1, SCK, PB2] 7 | <--- STW/SCK  [A/~]
' [0]    TAS ---> | 3 [PB4]               [MISO, PB1] 6 | <--- STA/MISO [1/~]
'        GND ==== | 4 [GND]               [MOSI, PB0] 5 | ---> EIN/MOSI [0/~]
'                  -------------------------------------
'
' Werte in []: Einstellungen nach dem Programmstart
'  ~: Impuls   0: aus   1: ein   A: analog
'
'08. I/O-Ports
'-------------
'Abkrzungen fr die Signalbezeichnung
'-------------------------------------
' /Reset  : Resetfunktion
' EIN     : Steuerung des Halbleiterschalters
' LED     : Anschluss fr LED
' STA     : Status                         Pegel bei Ausfall: 0
' STW     : Stromwert (analoger Kanal)
' TAS     : Taster
'
' P5V     : Stromversorgung P 5V
' GND     : Stromversorgung Masse
'
'Portbelegung
'------------
'           Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' -   : SV  P5V_D ...... | ............. | Stromversorgung .............. |  8
' -   : SV  GND_D ...... | ............. | Stromversorgung .............. |  4
' -   : PRG /RESET ..... | ............. | Programmierung/Reset des MCs . |  1
'
'Port B     Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' - .0: PRG MOSI ....... | MOSI/EIN .... | Programmierung/Einschalten ... |  5
' - .1: PRG MISO ....... | MISO/STA .... | Programmierung/Status ........ |  6
' - .2: PRG SCK ........ | SCK/STW ..... | Programmierung/Stromwert ..... |  7
' - .3: DA  Anzeige .... | LED ......... | Anzeige ...................... |  2
' - .4: DE  Taster ....  | TAS ......... | Befehlseingabe ............... |  3
' - .5: ................ | ............. | .............................. |  -
' - .6: ................ | ............. | .............................. |  -
' - .7: ................ | ............. | .............................. |  -
'
'09. Steckverbinder
'------------------
'Beschreibung entfllt
'
'-------------------------------------------------------------------------------
'
'10. Definition
'--------------
'Schaltkreis
'-----------
   $regfile = "attiny13.dat"                      'Prozessor ....... : ATtiny13

'Damit die auf "Waitstates" beruhenden BASCOM-Befehle richtig rechnen, muss man
'dem Compiler die Ziel-Taktrate ber den Befehl "$crystal" mitteilen, obwohl der
'ATtiny13 nicht ber eine Anschlussmglichkeit fr einen Quarz verfgt.
   $crystal = 9600000                             'int. Frequenz ... : 9,6 MHz

'Schnittstelle
'-------------
'entfllt

'Compilereinstellungen
'---------------------
   $hwstack = 16                                  'Hardware stack
   $swstack = 16                                  'Software stack
   $framesize = 8                                 'Frame space
'
'-------------------------------------------------------------------------------
'
'11. Deklaration
'---------------
'Flag
   Dim F_ea As Bit                                'Ein/Aus
   Dim F_st As Bit                                'Strung

'Variable
   Dim I As Word                                  'Stromwert vom Sensor
   Dim Iw As Long                                 'Strommittelwert

'Zhler
   Dim Z_lb As Word                               'Zeit: Lebensbit
   Dim Z_i As Byte                                'Strommessung

   Dim Hz01 As Byte                               'Hilfszhler 01
'
'-------------------------------------------------------------------------------
'
'12. Konfiguration
'-----------------
'I/O-Port
'--------
'=Port B
'-Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddrb = &B0000_1001                             'PB1,2,4-7 Ein; PB0,3 Aus
'-Pullup-Widerstand (passiv [0], aktiv [1])
   Portb = &B0001_0010                            'PB0,2,3 passiv; PB1,4 aktiv
'
'-------------------------------------------------------------------------------
'
'Timer
'-----
'Normal-Konfiguration (f int: interne Frequenz des MCs)
'Die Timerinterrupt 0 wird beim jeweiligen Timerberlauf ausgelst.
'                                    PSC  TVE   T        f
' T0 = 1/ f int* Teiler (1/ 9,6 MHz* 256* 38 =  1,01 ms; 987 Hz)

'Timer0 voreinstellen auf Wert: 256-TVE
   Config Timer0 = Timer , Prescale = 256         'Konfiguration
      Timer0 = 218                                'Voreinstellung
'
'-------------------------------------------------------------------------------
'
'ADC
'---
'Auto ....... : Einstellung des hchstmglichen Taktes fr den ADC
'Internal ... : Referenzspannung 1,1 V
   Config Adc = Single , Prescaler = Auto , Reference = Internal
'
'-------------------------------------------------------------------------------
'
'Interrupt
'---------
   Enable Timer0                                  'Timer 0: Interrupt
      On Timer0 Int_tim0                          'Timer 0: berlauf
'
'-------------------------------------------------------------------------------
'
'13. Alias
'---------
'Eingang (digital)
'-----------------
'Port B
   Sta Alias Pinb.1                               'Status
   Tas Alias Pinb.4                               'Taste

'Ausgang (digital)
'-----------------
'Port B
   Hls Alias Portb.0                              'Halbleiterschalter
   Led Alias Portb.3                              'LED-Anzeige
'
'-------------------------------------------------------------------------------
'
'14. Initialisierung
'-------------------
'Blinken
'-------
'beim Programmstart bzw. nach einem Reset
   For Hz01 = 1 To 6
      Led = Not Led                               'LED (3x)
      Waitms 500
   Next Hz01

'Lebensbit jetzt aktivieren
   Enable Interrupts                              'Interrupts: global zulassen
'
'-------------------------------------------------------------------------------
'
'20. Programm
'------------
Do
'Tastenabfrage
'-------------
'Mit jedem Tastendruck wird eine Umschaltung des Ausganges vorgenommen.
   If Tas = 0 Then                                'Abfrage: Taster
      Waitms 20                                   'Entprellzeit
      Led = 0
M_tas:
      If Tas = 0 Then                             'Abfrage: Taster
         Goto M_tas
      End If
      F_ea = Not F_ea                             'Umschalten, wenn /Taste
      F_st = 0                                    'ggf. Strung lschen
   End If

'Schalten
'--------
'HLS und LED-Anzeige schalten
   If F_st = 0 And F_ea = 1 Then                  'keine Strung, Flag HSL Ein
      Start Adc                                   'ADC starten
      Hls = 1                                     'HSL Ein
      Led = 1                                     'Anzeige ein
   Else
      Hls = 0                                     'HSL Aus
   End If

'Fehler
'------
'Strung HLS oder Stromwert berschritten
'Das Flag F_st wird bei einer Stromwertberschreitung gesetzt.
   If F_st = 1 Or Sta = 0 Then                    'Abfrage: Flag Strung, Status
      Hls = 0                                     'HSL Aus
      F_ea = 0                                    'Flag Aus
      Stop Adc                                    'ADC stoppen
      Led = Not Led                               'Anzeige blinkt
      Waitms 500
   End If

Loop

'Ende Programm
End

'===============================================================================

'-------------------------------------------------------------------------------
'30. === U N T E R P R O G R A M M =============================================
'-------------------------------------------------------------------------------

'-------------------------------------------------------------------------------
'40. === I N T E R R U P T R O U T I N E =======================================
'-------------------------------------------------------------------------------

'Timer 0
'-------
Int_tim0:
'Interrupt: Timer 0 (8 Bit), alle 1 ms
'                                    PSC  TVE   T        f
' T0 = 1/ f int* Teiler (1/ 9,6 MHz* 256* 38 =  1,01 ms; 987 Hz)
'Voreinstellung des Zhlers
   Timer0 = 218                                   'Voreinstellung (1 ms)

'Zeitzhler
   Incr Z_lb                                      'Zhler: Lebensbit
   Incr Z_i                                       'Zhler: Stromwert

 'Lebensbit
   If F_ea = 0 And F_st = 0 Then                  'HSL aus, keine Strung
      Select Case Z_lb
         Case 1
            Led = 1                               'LED Ein
         Case 15
            Led = 0                               'LED Aus
         Case Is > 2000                           'Wartezeit
            Z_lb = 0
      End Select
   End If

'Ermittlung und Prfung des Stromwertes
'--------------------------------------
'Sie erfolgt in diesen Programmbeispiel in 3 Schritten in einem Abstand von
'drei Millisekunden.
'Durch die Mittelwertbildung werden Stromspitzen ausgeblendet.
   Select Case Z_i
      Case 1                                      'Stromwert 1 ermitteln
         I = Getadc(1)
         Iw = I
      Case 2                                      'Stromwert 2 ermitteln
         I = Getadc(1)
         Iw = Iw + I
      Case 3                                      'Auswertung
         Iw = Iw / 2                              'Mittelwertbildung

'Abschaltung des HLS, wenn der Grenzwert unterschritten wurde
'Wahl der Referenzspannung (Genauigkeit bei 2^10 = 1024 Stufen):
' 1,1 V       - ergibt: 1,1 V/ 1024 = 1,0742*EXP-3 V/Stufe)
' 5,0 V (Vcc) - ergibt: 5,0 V/ 1024 = 4,8828*EXP-3 V/Stufe)

'Der Wert von 500 ist unkritisch und gilt beim Einsatz eines Spannungsteilers.
'Dieser ist bei der Verwendung der internen Referenzspannungsquelle erforder-
'lich, da der Stromsensor bei einem Stromwert von 0 A eine Ausgangsspannung
'von 2,5 V ausgibt.
         If Iw < 500 Then                         '500 mV
            Hls = 0                               'HLS .......... : Aus
            F_st = 1                              'Flag_Strung . : Ein
         End If
'Initialisierung fr eine neue Messung
         Z_i = 0
   End Select

Return

'-------------------------------------------------------------------------------
'50. === U N T E R P R O G R A M M - C A L L ===================================
'-------------------------------------------------------------------------------

'-------------------------------------------------------------------------------
'60. === F U N K T I O N =======================================================
'-------------------------------------------------------------------------------

'-------------------------------------------------------------------------------
'70. === D A T E N B E R E I C H ===============================================
'-------------------------------------------------------------------------------

'Ende

'###############################################################################